% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{addGeneSetMetadata}
\alias{addGeneSetMetadata}
\title{Add metadata at the geneset level.}
\usage{
addGeneSetMetadata(x, meta, ...)
}
\arguments{
\item{x}{a \code{GeneSetDb} object}

\item{meta}{a \code{data.frame}-like object with \code{"collection"}, \code{"name"}, and
an arbitrary amount of columns to add as metadata for the genesets.}

\item{...}{not used yet}
}
\value{
the updated \code{GeneSetDb} object \code{x}.
}
\description{
This function adds/updates columns entries in the \code{geneSets(gdb)} table.
If there already are defined meta values for the columns of \code{meta} in \code{x},
these will be updated with the values in \code{meta}.
}
\details{
TODO: should this be a setReplaceMethod, Issue #13 (?)
https://github.com/lianos/multiGSEA/issues/13
}
\examples{
gdb <- exampleGeneSetDb()
meta.info <- transform(
  geneSets(gdb)[, c("collection", "name")],
  someinfo = sample(c("one", "two"), nrow(gdb), replace = TRUE))
gdb <- addGeneSetMetadata(gdb, meta.info)
}
