% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{annotateGeneSetMembership}
\alias{annotateGeneSetMembership}
\title{Annotates rows of a data.frame with geneset membership from a GeneSetDb}
\usage{
annotateGeneSetMembership(x, gdb, x.ids = NULL, ...)
}
\arguments{
\item{x}{A data.frame with genes/features in rows}

\item{gdb}{A \code{\link[=GeneSetDb]{GeneSetDb()}} object with geneset membership}

\item{x.ids}{The name of the column in \code{x} that holds the feautre
id's in \code{x} that match the feature_id's in \code{gdb}, or a vector
of id's to use for each row in \code{x} that represent these.}

\item{...}{parameters passed down into \code{\link[=incidenceMatrix]{incidenceMatrix()}}}
}
\value{
Returns the original \code{x} with additional columns: each is a
logical vector that indicates membership for genesets defined in
\code{gdb}.
}
\description{
This is helpful when you don't have a monsterly sized GeneSetDb. There will
be as many new columns added to \code{x} as there are active genesets in \code{gdb}.
}
\examples{
vm <- exampleExpressionSet()
gdb <- exampleGeneSetDb()
mg <- seas(vm, gdb, design = vm$design, contrast = 'tumor')
lfc <- logFC(mg)
annotated <- annotateGeneSetMembership(lfc, gdb, 'feature_id')

## Show only genes that are part of 'HALLMARK_ANGIOGENESIS' geneset
angio <- subset(annotated, `c2;;BIOCARTA_AGPCR_PATHWAY`)
}
