% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R,
%   R/SparrowResult-methods.R
\name{geneSet}
\alias{geneSet}
\alias{geneSet,GeneSetDb-method}
\alias{geneSet,SparrowResult-method}
\title{Fetches information for a gene set}
\usage{
geneSet(x, i, j, ...)

\S4method{geneSet}{GeneSetDb}(
  x,
  i,
  j,
  active.only = is.conformed(x),
  with.feature.map = FALSE,
  ...,
  collection = NULL,
  name = NULL,
  as.dt = FALSE
)

\S4method{geneSet}{SparrowResult}(
  x,
  i,
  j,
  active.only = TRUE,
  with.feature.map = FALSE,
  ...,
  collection = NULL,
  name = NULL,
  as.dt = FALSE
)
}
\arguments{
\item{x}{Object to retrieve the gene set from, either a \code{GeneSetDb} or a
\code{SparrowResult}.}

\item{i, j}{The collection,name compound key identifier of the gene set}

\item{...}{passed down to inner functinos}

\item{active.only}{only look for gene sets that are "active"? Defaults to
\code{TRUE} if \code{x} is conformed to a target expression object, else \code{FALSE}.
\code{\link[=conform]{conform()}} for further details.}

\item{with.feature.map}{If \code{TRUE}, then details of the feature mapping
from the original feature_id space to the target feature space are included
(default: \code{FALSE}).}

\item{collection}{using \code{i} as the parameter for "collection" isn't intuitive
so if speficially set this paramter, it will replace the value for \code{i}.}

\item{name}{the same for the \code{collection}:\code{i} parameter relationship, but for
\code{j}:\code{name}.}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
a \code{data.(frame|table)} of gene set information. If \code{x} is a
\code{SparrowResult} object, then differential expression statistics
are added as columns to this result.
}
\description{
Gene sets inside a \code{\link[=GeneSetDb]{GeneSetDb()}} are indexed by their collection,name
compound key. There is no special class to represent an individual gene set.
Instead, gene sets are returned as a data.frame, the rows of which enumerate
the features that belong to them.

When \code{x} is a \code{\link[=SparrowResult]{SparrowResult()}}, this function will append
the differential expression statistics for the individual features generated
across the contrast that defined \code{x}.
}
\examples{
gdb <- exampleGeneSetDb()
geneSet(gdb, "c2", "KOMMAGANI_TP63_GAMMA_TARGETS")
geneSet(gdb, collection = "c2", name = "KOMMAGANI_TP63_GAMMA_TARGETS")
geneSet(gdb, name = "KOMMAGANI_TP63_GAMMA_TARGETS")
}
