% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R,
%   R/SparrowResult-methods.R
\name{geneSets}
\alias{geneSets}
\alias{length,GeneSetDb-method}
\alias{geneSets,GeneSetDb-method}
\alias{nrow,GeneSetDb-method}
\alias{geneSets,SparrowResult-method}
\title{Fetch the active (or all) gene sets from a GeneSetDb or SparrowResult}
\usage{
geneSets(x, ...)

\S4method{length}{GeneSetDb}(x)

\S4method{geneSets}{GeneSetDb}(x, active.only = is.conformed(x), ..., as.dt = FALSE)

\S4method{nrow}{GeneSetDb}(x)

\S4method{geneSets}{SparrowResult}(x, ..., as.dt = FALSE)
}
\arguments{
\item{x}{Object to retrieve the gene set from, either a \code{GeneSetDb} or a
\code{SparrowResult}.}

\item{...}{pass through arguments}

\item{active.only}{only look for gene sets that are "active"? Defaults to
\code{TRUE} if \code{x} is conformed to a target expression object, else \code{FALSE}.
\code{\link[=conform]{conform()}} for further details.}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
a data.table with geneset information.
}
\description{
Fetch the active (or all) gene sets from a GeneSetDb or SparrowResult
}
\section{Methods (by class)}{
\itemize{
\item \code{length(GeneSetDb)}: Returns the number of genesets in a GeneSetDb

\item \code{geneSets(GeneSetDb)}: return all genesets from a GeneSetDb

\item \code{nrow(GeneSetDb)}: return number of genesets in GeneSetDb

\item \code{geneSets(SparrowResult)}: return the active genesets from a SparrowResult

}}
\examples{
gdb <- exampleGeneSetDb()
gs <- geneSets(gdb)
}
