% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-panther.R
\name{getPantherCollection}
\alias{getPantherCollection}
\alias{getPantherGeneSetDb}
\title{Get pathways/GOslim collections from PANTHER.db Biocondcutor package.}
\usage{
getPantherCollection(
  type = c("pathway", "goslim"),
  species = c("human", "mouse")
)

getPantherGeneSetDb(
  type = c("pathway", "goslim"),
  species = c("human", "mouse")
)
}
\arguments{
\item{type}{"pathway" or, "goslim"}

\item{species}{"human" or "mouse"}
}
\value{
A BiocSet of panther pathways
}
\description{
This is a convience function that orchestrates the PANTHER.db package to
return GeneSetDb objects for either pathway or GOslim information for
human or mouse.
}
\details{
Note that for some reason the \code{PANTHER.db} package needs to be
installed in a user-writable package location for this to work properly.
If you see an error like "Error in resqlite_send_query ... attempt to
write a readonly database", this is the problem. Please install another
version of the \code{PANTHER.db} package in a user-writable directory using
\code{\link[BiocManager:install]{BiocManager::install()}}.
}
\section{Functions}{
\itemize{
\item \code{getPantherGeneSetDb()}: returns a GeneSetDb

}}
\section{GOSLIM}{

\href{http://geneontology.org/page/go-slim-and-subset-guide}{GO Slims} are
"cut down" versions of the GO ontology that contain a subset of the terms in
the whole GO.

PANTHER provides their own set of
\href{http://www.pantherdb.org/panther/ontologies.jsp}{GO slims}, although
it's not clear how often these get updated.
}

\examples{
\donttest{
# this requires you have the PANTHER.db package installed via BiocManager
bsc.panther <- getPantherCollection(species = "human")
}
}
