% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparrowResult-methods.R
\name{p.matrix}
\alias{p.matrix}
\title{Assembles a matrix of nominal or adjusted pvalues from a sparrow::seas result}
\usage{
p.matrix(
  x,
  names = resultNames(x),
  pcol = c("padj", "padj.by.collection", "pval")
)
}
\arguments{
\item{x}{A \code{\link[=SparrowResult]{SparrowResult()}} object.}

\item{names}{the entries from \code{resultNames(x)} that you want to include
in the matrix. By default we take all of them.}

\item{pcol}{The name of the column in \code{logFC(x)} where the type of pvalues
are that we are collection. Pick on of \code{"padj"}, \code{"padj.by.collection"},
or \code{"pval"}}
}
\value{
A matrix of the desired pvalues for all genesets
}
\description{
You might want a matrix of pvalues (or FDRs) for the gene sets across all
GSEA methods you tried. I think I did, once, so here it is.
}
\examples{
mg <- exampleSparrowResult()
pm <- p.matrix(mg)
}
