% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing-helpers.R
\name{randomGeneSetDb}
\alias{randomGeneSetDb}
\title{Generates a fake GeneSetDb by sampling from features in a seas input.}
\usage{
randomGeneSetDb(x, n = 10, bias = NULL, include_spaces = TRUE, ...)
}
\arguments{
\item{x}{an input container to \code{\link[=seas]{seas()}}}

\item{n}{number of genesets}

\item{bias}{column in \code{x} to bias the geneset creation by}

\item{include_spaces}{If \code{TRUE} (default), geneset names will have a space
in them. This is used to test corner cases around the assumption of
geneset naming conventions.}

\item{...}{pass through args}
}
\value{
A randomly generated GeneSetDb you can use against \code{x} for testing.
}
\description{
I wrote this because initial fetching from msigdbr can be slow, and also
having some weird crashes in the unit tests of bioc3.14-devel.
}
\details{
This is a helper function for development, and shouldn't be used by normal
users of this package.
}
\examples{
gdb.rando <- randomGeneSetDb(exampleDgeResult(), 10, bias = "t")
}
