% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_direct.R
\name{assess_direct}
\alias{assess_direct}
\title{The assess_direct() function}
\usage{
assess_direct(PREC_for_graph, OMEGA_for_graph, p)
}
\arguments{
\item{PREC_for_graph}{It is the known precision matrix which is used to
assess the estimated precision matrix from GGM.}

\item{OMEGA_for_graph}{It is the estimated precision matrix from a GGM.}

\item{p}{It is an integer representing the number of dimension of both the
known and estimated precision matrix.}
}
\value{
Return the list of assessment results including sensitivity,
specificity, NPV(test negative), PPV(test positive), true positive
and true negative.
}
\description{
The assess_direct function is designed to 
evaluate the prediction accuracy of a Gaussian Graphical model(GGM) 
comparing with the true graph structure with a known precision matrix.
}
\examples{
prec1 <- matrix(c(0,2,3,1,0,0.5,0,0,0.4),nrow=3,ncol=3)
prec0 <- matrix(c(0,1,2,1,0.5,0.2,0,1,1),nrow=3,ncol=3)

assessresult <- assess_direct(prec1,prec0,p=3)

}
