% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_simulate.R
\name{spatial_simulate}
\alias{spatial_simulate}
\title{Simulate SpatialExperiment object}
\usage{
spatial_simulate(
  n_genes,
  proportion,
  coords,
  range_sigma.sq,
  range_beta,
  length_scale,
  length_scale_option = "fixed"
)
}
\arguments{
\item{n_genes}{an integer specifying the number of genes to simulate.}

\item{proportion}{a numeric value specifying the proportion of genes that will have
no spatially varying patterns.}

\item{coords}{a matrix of coordinates.}

\item{range_sigma.sq}{a numeric vector of length 2 specifying the range of the spatial
variance parameter.}

\item{range_beta}{a numeric vector of length 2 specifying the range of the mean
expression value.}

\item{length_scale}{if length_scale_option is "fixed", a numeric value specifying the
length scale parameter. If length_scale_option is "unique", a numeric vector of length
n_genes specifying the length scale parameter for each gene.}

\item{length_scale_option}{a character string specifying the length scale option.
Options are "fixed" for a single length scale for all genes or "unique" for a unique
length scale for each gene.}
}
\value{
A SpatialExperiment object with the simulated data.
}
\description{
Simulate a SpatialExperiment object with spatially varying genes
}
\details{
This function simulates a SpatialExperiment object with spatially varying
genes. The function takes in the number of genes to simulate, the proportion of
genes that will have no spatially varying patterns, a matrix of coordinates, the
range of the spatial variance parameter, the range of the mean expression value,
the length scale parameter, and the length scale option.
}
\examples{
library(STexampleData)

set.seed(1)
n_genes <- 1
proportion <- 0.5
range_sigma.sq <- c(0.2, 3)
range_beta <- c(0.5, 9)
length_scale <- 60

spe_demo <- Visium_mouseCoronal()
colData(spe_demo)$subset <- ifelse(
  colData(spe_demo)$array_row > 20 &
  colData(spe_demo)$array_row < 65 &
  colData(spe_demo)$array_col > 30 &
  colData(spe_demo)$array_col < 65,
  TRUE, FALSE
)
spe_demo <- spe_demo[, colData(spe_demo)$subset]
coords <- spatialCoords(spe_demo)

spe <- spatial_simulate(n_genes, proportion, coords, range_sigma.sq, range_beta,
   length_scale, length_scale_option = "fixed")

}
