% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_frag_info.R
\name{add_frag_info}
\alias{add_frag_info}
\title{decode fragment identifiers for spike-in standards}
\usage{
add_frag_info(x, frag_grp = "frag_grp", spike = NULL)
}
\arguments{
\item{x}{data.frame with a column of spike information (see above)}

\item{frag_grp}{column name for the spike contig information (\code{frag_grp})}

\item{spike}{optional database of spike-in properties (none)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     the data.frame x, augmented with metadata columns
}\if{html}{\out{</div>}}
}
\description{
given a vector of fragment identifiers like \verb{160_2_35} or \verb{80b_1C_35G-2},
encoded typically as lengthInBp_numberOfCpGs_GCpercent, and optionally a
database of spike-in sequences corresponding to those fragments, add those
columns to the source data (along with, if present in the database, other
metadata such as standard concentrations, GC fraction, etc.) and return i
an updated DataFrame.
}
\examples{
data(spike_cram_counts) 
data(spike, package="spiky") 
spike <- subset(spike, methylated == 1)
add_frag_info(spike_cram_counts, spike=spike)

}
