% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bedpe.R
\name{read_bedpe}
\alias{read_bedpe}
\title{read a BEDPE file into Pairs of GRanges (as if a GAlignmentPairs or similar)}
\usage{
read_bedpe(
  x,
  ...,
  stranded = FALSE,
  fraglen = TRUE,
  optional = FALSE,
  keep = FALSE
)
}
\arguments{
\item{x}{a Tabixed BEDPE file, or a TabixFile of one}

\item{...}{additional arguments to pass to scanTabix internally}

\item{stranded}{Is the data stranded? (FALSE)}

\item{fraglen}{compute the fragment length? (TRUE)}

\item{optional}{scan the optional columns (name, score, strand1)? (FALSE)}

\item{keep}{keep additional columns? (FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     a Pairs of GRanges, perhaps with $score or $fraglen
}\if{html}{\out{</div>}}
}
\description{
read a BEDPE file into Pairs of GRanges (as if a GAlignmentPairs or similar)
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    BEDPE import in R is a shambles. This is a bandaid on a GSW.
             See the \\href\{https://bedtools.readthedocs.io/en/latest/content/general-usage.html#bedpe-format\}\{BEDPE format definition\} for full details.
             In short, for a pair of ranges 1 and 2, we have fields
             chrom1, start1, end1, chrom2, start2, end2, and (optionally)
             name, score, strand1, strand2, plus any other user defined
             fields that may be included (these are not yet supported
             by read_bedpe). For example, two valid BEDPE lines are:

             chr1  100   200   chr5  5000  5100  bedpe_example1  30
             chr9  900  5000   chr9  3000  3800  bedpe_example2  99  +  -
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
  bedpe <- "GSM5067076_2020_A64_bedpe.bed.gz"
  WT1_hg38 <- GRanges("chr11", IRanges(32387775, 32435564), "-")
  read_bedpe(bedpe, param=WT1_hg38)
}

}
\seealso{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    bedpe_covg
}\if{html}{\out{</div>}}
}
