% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqinfo_from_header.R
\name{seqinfo_from_header}
\alias{seqinfo_from_header}
\title{create seqinfo (and thus a standard chromosome filter) from a BAM header}
\usage{
seqinfo_from_header(x, gen = NA, std = FALSE, ret = c("si", "gr"))
}
\arguments{
\item{x}{the BAM file or its header}

\item{gen}{genome of the BAM file, if known (NULL; autodetect)}

\item{std}{standard chromosomes only? (FALSE; will be empty if spikes)}

\item{ret}{return Seqinfo ("si", the default) or GRanges ("gr")? ("si")}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   Seqinfo object or GRanges (or `as(seqinfo, "GRanges")`)
}\if{html}{\out{</div>}}
}
\description{
create seqinfo (and thus a standard chromosome filter) from a BAM header
}
\details{
Setting std=TRUE on a spike-in BAM will produce an empty result.
}
\examples{

  library(Rsamtools)
  fl <- system.file("extdata", "ex1.bam", package="Rsamtools", mustWork=TRUE)

  hdr <- scanBamHeader(BamFile(fl))
  si <- seqinfo_from_header(hdr)
  gr <- seqinfo_from_header(fl, ret="gr")
  stopifnot(identical(gr, as(si, "GRanges")))

  std_si <- seqinfo_from_header(fl, std=TRUE)
  seqlevels(std_si)

  # for comparison with below
  data(spike, package="spiky")
  spike

  sp <- system.file("extdata", "example.spike.bam", package="spiky")
  sp_gr <- seqinfo_from_header(sp, ret="gr")
  sp_gr

}
