% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compensate.R
\name{compensate}
\alias{compensate}
\title{Compute spillover probability and correct for spillover}
\usage{
compensate(
  tb_real,
  tb_bead,
  target_marker,
  spillover_markers,
  impute_value = NA,
  n_iter = 1000
)
}
\arguments{
\item{tb_real}{Data frame or tibble with proteins counts of real experiment}

\item{tb_bead}{Data frame or tibble with proteins counts of bead experiment}

\item{target_marker}{Marker name in real experiment}

\item{spillover_markers}{Marker names in bead experiment}

\item{impute_value}{Value for counts that are declared as spillover}

\item{n_iter}{Maximum number of EM steps}
}
\value{
A list of class \code{spillr} containing
  \item{tb_compensate}{corrected real cells}
  \item{tb_spill_prob}{probability curve}
  \item{convergence}{covergence table of EM algorithm}
  \item{tb_real}{input real cells}
  \item{tb_bead}{input bead cells}
  \item{target_marker}{input marker in real experiment}
  \item{spillover_markers}{input markers in bead experiment}
}
\description{
Compute spillover probability and correct for spillover
}
