% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple-estimate.R
\name{simpleEstimate}
\alias{simpleEstimate}
\alias{simpleEstimate.SingleCellExperiment}
\alias{simpleEstimate.matrix}
\title{Estimate simple simulation parameters}
\usage{
simpleEstimate(counts, params = newSimpleParams())

\method{simpleEstimate}{SingleCellExperiment}(counts, params = newSimpleParams())

\method{simpleEstimate}{matrix}(counts, params = newSimpleParams())
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{SimpleParams object to store estimated values in.}
}
\value{
SimpleParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the simple simulation from a real dataset.
}
\details{
The \code{nGenes} and \code{nCells} parameters are taken from the size of the
input data. The mean parameters are estimated by fitting a gamma distribution
to the library size normalised mean expression level using
\code{\link[fitdistrplus]{fitdist}}. See \code{\link{SimpleParams}} for more
details on the parameters.
}
\examples{
# Load example data
library(scuttle)
set.seed(1)
sce <- mockSCE()

params <- simpleEstimate(sce)
params
}
