% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{summariseDiff}
\alias{summariseDiff}
\title{Summarise diffSCEs}
\usage{
summariseDiff(diff)
}
\arguments{
\item{diff}{Output from \code{\link{diffSCEs}}}
}
\value{
data.frame with MADs, MAEs, RMSEs, scaled statistics and ranks
}
\description{
Summarise the results of \code{\link{diffSCEs}}. Calculates the Median
Absolute Deviation (MAD), Mean Absolute Error (MAE), Root Mean Squared
Error (RMSE) and Kolmogorov-Smirnov (KS) statistics for the various
properties and ranks them.
}
\examples{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
difference <- diffSCEs(list(Splat = sim1, Simple = sim2), ref = "Simple")
summary <- summariseDiff(difference)
head(summary)
}
