% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getAlpha}
\alias{getAlpha}
\alias{getAlpha}
\alias{getAlpha,stageR}
\alias{getAlpha,stageRTx}
\alias{getAlpha,stageRTx-method}
\title{Retrieve the significance level for the stage-wise adjustment.}
\usage{
getAlpha(object, ...)

\S4method{getAlpha}{stageR}(object, ...)

\S4method{getAlpha}{stageRTx}(object, ...)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} or \code{stageRTxClass} class.}

\item{...}{Additional arguments}
}
\value{
Returns a calar vector with the OFDR alpha level that was specified by the user.
}
\description{
This functions returns the significance level on which the stage-wise adjustment is based.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Retrieve the significance level for the stage-wise adjustment.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
getAlpha(stageRObj)
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
