% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumBatchCorEval.R
\name{computeClusterEvalStats}
\alias{computeClusterEvalStats}
\title{Calculate statistics for evaluating batch correction}
\usage{
computeClusterEvalStats(
  spe_object,
  foiColumn,
  precomputed = NULL,
  n_dimension = c(1, 2),
  assay = 2
)
}
\arguments{
\item{spe_object}{A Spatial Experiment object.}

\item{foiColumn}{A column name indicating the factor of interest to be tested, can be biological factor or batch factor.}

\item{precomputed}{a dimensional reduction results from \code{stats::prcomp}.
result in \code{reducedDims(object)} to plot. Default is NULL,
we will compute for you.}

\item{n_dimension}{The top n dimensions to be plotted}

\item{assay}{a numeric or character, specifying the assay to use (for
\code{SummarizedExperiment} and its derivative classes).}
}
\value{
A dataframe object containing the clustering evaluating statistics.
}
\description{
Calculate statistics for evaluating batch correction
}
\examples{
library(scater)
data("dkd_spe_subset")
computeClusterEvalStats(dkd_spe_subset, "SlideName")

}
