% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaOtherPlotting.R
\name{plotPCAbiplot}
\alias{plotPCAbiplot}
\title{Plot PCA bi plot}
\usage{
plotPCAbiplot(
  spe_object,
  n_loadings = 10,
  dims = c(1, 2),
  precomputed = NULL,
  assay = 1,
  arrow_x = 0,
  arrow_y = 0,
  ...
)
}
\arguments{
\item{spe_object}{A SpatialExperiment object.}

\item{n_loadings}{Plot the top n gene loadings}

\item{dims}{The top n dimensions to be plotted}

\item{precomputed}{a dimensional reduction results from \code{stats::prcomp}.
result in \code{reducedDims(object)} to plot. Default is NULL,
we will compute for you.}

\item{assay}{a numeric or character, specifying the assay to use (for
\code{SummarizedExperiment} and its derivative classes).}

\item{arrow_x}{a numeric, indicating the x coordinate of the base of the arrow.}

\item{arrow_y}{a numeric, indicating the y coordinate of the base of the arrow.}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes()}.}
}
\value{
A ggplot object.
}
\description{
Plot PCA bi plot
}
\examples{
data("dkd_spe_subset")
plotPCAbiplot(dkd_spe_subset)
}
