% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomx_import_data.R
\name{readGeoMx}
\alias{readGeoMx}
\title{Import GeoMX DSP data into a saptial experiment object from file paths}
\usage{
readGeoMx(
  countFile,
  sampleAnnoFile,
  featureAnnoFile = NA,
  rmNegProbe = TRUE,
  NegProbeName = "NegProbe-WTX",
  colnames.as.rownames = c("TargetName", "SegmentDisplayName", "TargetName"),
  coord.colnames = c("ROICoordinateX", "ROICoordinateY")
)
}
\arguments{
\item{countFile}{tsv file or a dataframe object. Count matrix, with samples in columns and features/genes in rows. The first column is gene names/ids.}

\item{sampleAnnoFile}{tsv file or a dataframe object. Sample annotations.}

\item{featureAnnoFile}{tsv file or a dataframe object. Feature/Gene annotations.}

\item{rmNegProbe}{Logical. Default is TRUE, indicating there are negative probe genes in the data.}

\item{NegProbeName}{Character. Name of negative probe genes, default is NegProbe-WTX.}

\item{colnames.as.rownames}{Vector of characters, length of 3. Column names used to capture gene names, sample names and gene names in countFile, sampleAnnoFile and featureAnnoFile, respectively.}

\item{coord.colnames}{Vector of characters, length of 2. Column names used to capture ROI coordinates.}
}
\value{
A SpatialExperiment object.
}
\description{
Import GeoMX DSP data into a saptial experiment object from file paths
}
\examples{
library(ExperimentHub)

eh <- ExperimentHub()
query(eh, "standR")
countFile <- eh[["EH7364"]]
sampleAnnoFile <- eh[["EH7365"]]

spe <- readGeoMx(countFile, sampleAnnoFile, rmNegProbe = FALSE)

}
