% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda_feature_significance_chart.R
\name{plsda_feature_importance_plot}
\alias{plsda_feature_importance_plot}
\title{PLSDA feature importance summary plot}
\usage{
plsda_feature_importance_plot(n_features = 30, metric = "vip", ...)
}
\arguments{
\item{n_features}{(numeric, integer) The number of features to include in the summary. The default is \code{30}.\cr}

\item{metric}{(character) Metric to plot. Allowed values are limited to the following: \itemize{ \item{\code{"sr"}: Plot Selectivity Ratio.}\item{\code{"sr_pvalue"}: Plot SR p-values.}\item{\code{"vip"}: Plot Variable Importance in Projection scores.}} The default is \code{"vip"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
plsda_feature_importance_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A plot of the selected feature significance metric for a PLSDA model for the top selected features.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}} \item{\code{ggplot2}} \item{\code{reshape2}} \item{\code{cowplot}}}
}
\section{Inheritance}{

A \code{plsda_feature_importance_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[plsda_feature_importance_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = plsda_feature_importance_plot(
      n_features = 50,
      metric = "vip")

D = iris_DatasetExperiment()
M = mean_centre()+PLSDA(factor_name='Species')
M = model_apply(M,D)

C = plsda_feature_importance_plot(n_features=30,metric='vip')
chart_plot(C,M[2])
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.

Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.

Wickham H (2007). "Reshaping Data with the reshape Package." \emph{Journal
of Statistical Software}, \emph{21}(12), 1-20.
\url{http://www.jstatsoft.org/v21/i12/}.

Wilke C (2024). \emph{cowplot: Streamlined Plot Theme and Plot Annotations
for 'ggplot2'}. R package version 1.1.3,
\url{https://CRAN.R-project.org/package=cowplot}.
}
