% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_chart_class.R
\name{tic_chart}
\alias{tic_chart}
\title{Total Ion Count chart.}
\usage{
tic_chart(run_order, factor_name, connected = FALSE, ...)
}
\arguments{
\item{run_order}{(character) The column name of sample_meta indicating the run order of the samples.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{connected}{(logical) Plot samples connected by a grey line. The default is \code{FALSE}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
tic_chart
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A scatter plot of Total Ion Count (sum of each sample) versus run order.
}
\section{Inheritance}{

A \code{tic_chart} object inherits the following \code{struct} classes: \cr\cr
\verb{[tic_chart]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = tic_chart(
      factor_name = "V1",
      run_order = character(0),
      connected = FALSE)

D = iris_DatasetExperiment()
D$sample_meta$run_order=1:nrow(D)
C = tic_chart(factor_name='Species',run_order='run_order')
chart_plot(C,D)

}
