% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankProdHits.R
\name{rankProdHits}
\alias{rankProdHits}
\title{Select hits by the rank product method}
\usage{
rankProdHits(masterPlate, dta, treatment, control, normMethod = "PLATE")
}
\arguments{
\item{masterPlate}{the master plate to be analyzed}

\item{dta}{synthetic lethal RNAi screen data}

\item{treatment}{the treatment condition in EXPERIMENT_MODIFICATION}

\item{control}{the control condition in EXPERIMENT_MODIFICATION}

\item{normMethod}{normalization methods to be used. If "PLATE", the raw readouts are normalized by plate median, otherwise use provided control siRNA}
}
\value{
A list contains results by the rank product method for each master plate.
\itemize{
  \item MASTER_PLATE: location of siRNA
  \item pvalue_treat_lowerthan_cont: p-value for the hypothesis that treatment has lower normalized readout compared to control
  \item FDR_treat_lowerthan_cont: FDR value
  \item treat_cont_log2FC: log2 fold change of treatment / control
}
}
\description{
Select hits by rank product methods by comparing treatment and control.
}
\examples{
data(example_dt)
res <- sapply(unique(example_dt$MASTER_PLATE),
              rankProdHits,
              example_dt,
              control   = "control",
              treatment = "treatment",
              simplify  = FALSE)
}
\references{
Breitling, R., Armengaud, P., Amtmann, A. & Herzyk, P. Rank products: a simple, yet powerful, new method to detect differentially regulated genes in replicated microarray experiments. FEBS Lett 573, 83-92 (2004).
Hong, F. et al. RankProd: a bioconductor package for detecting differentially expressed genes in meta-analysis. Bioinformatics 22, 2825-2827 (2006).
}
