% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siRNAPlot.R
\name{siRNAPlot}
\alias{siRNAPlot}
\title{Plot siRNA data and quality metrics.}
\usage{
siRNAPlot(
  gene,
  dta,
  controlsiRNA,
  FILEPATH = ".",
  colour = rainbow(10),
  zPrimeMed,
  zPrimeMean,
  treatment,
  control,
  normMethod = c("PLATE"),
  save_plot = FALSE,
  width = 15,
  height = 14
)
}
\arguments{
\item{gene}{gene symbol, case sensitive}

\item{dta}{synthetic lethal RNAi screen data}

\item{controlsiRNA}{controlsiRNA could be a vector of several siRNA, including postive/negative control}

\item{FILEPATH}{path to store the figure}

\item{colour}{colour used in graphs}

\item{zPrimeMed}{zPrime factor basing on median}

\item{zPrimeMean, }{zPrime factor basing on mean}

\item{treatment}{the treatment condition in EXPERIMENT_MODIFICATION}

\item{control}{the control condition in EXPERIMENT_MODIFICATION}

\item{normMethod}{could be a PLATE and negative controls}

\item{save_plot}{whether save a png file in the working directory.}

\item{width}{width of the plot}

\item{height}{height of the plot}
}
\value{
Return the ggplot2 objects in a list, which could be plotted individually.
}
\description{
Plot the normalized RNAi screen data, row data, control signals and Z' factor.
}
\examples{
data(example_dt)
zF_mean <- zFactor(example_dt, negativeCon = "scrambled control si1", positiveCon = "PLK1 si1")
zF_med  <- zFactor(example_dt, negativeCon = "scrambled control si1", positiveCon = "PLK1 si1",
                   useMean = FALSE)
p01 <- siRNAPlot("AAK1", example_dt,
                 controlsiRNA = c("lipid only", "scrambled control si1"),
                 FILEPATH = ".",  zPrimeMed = zF_med, zPrimeMean = zF_mean,
                 treatment = "treatment", control = "control",
                 normMethod = c("PLATE", "lipid only", "scrambled control si1"))
}
