# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @useDynLib syntenet, .registration = TRUE
#' @import Rcpp
#' @title rcpp_mcscanx_file
#' @name rcpp_mcscanx_file
#' @description MCSCanX provides a clustering module for viewing the
#' relationship of collinear segments in multiple genomes (or heavily redundant
#' genomes). It takes the predicted pairwise segments from dynamic programming
#' (DAGchainer in particular) and then tries to build consensus segments from a
#' set of related, overlapping segments.
#' @return NULL, and a .collinearity file is created in the directory
#' specified in \strong{`outdir`}.
#' @param blast_file Character indicating the path to the BLAST/DIAMOND output
#' file.
#' @param gff_file Character indicating the path to the "gff" file, which
#' is a tab-delimited file with 4 columns indicating the chromosome name,
#' gene id, gene start position, and gene end position, respectively.
#' @param prefix Character indicating the prefix to output files. 
#' Default: "out".
#' @param outdir Character indicating the path to the output directory. 
#' Default: "".
#' @param match_score Numeric indicating the match score. Default: 50.
#' @param gap_penalty Numeric indicating the gap penalty. Default: -1.
#' @param match_size Numeric indicating the minimum number of genes 
#' required to call synteny. Default: 5.
#' @param e_value Numeric indicating the minimum e-value allowed. 
#' Default: 1e-5.
#' @param max_gaps Numeric indicating the maximum number of gaps between
#' genes allowed. The unit measure of gaps is number of genes, 
#' so \code{max_gaps = 20} indicates that a maximum of 20 genes can
#' exist between two homologous genes for synteny to be called. Default: 25.
#' @param overlap_window Numeric indicating the overlap window. Default: 5.
#' @param is_pairwise Logical indicating whether only pairwise blocks 
#' should be reported. Default: FALSE.
#' @param in_synteny Numeric indicating the patterns of collinear blocks,
#' where 0 indicates intra and interspecies comparisons, 1 indicates
#' intraspecies comparisons, and 2 indicates interspecies comparisons. 
#' Default: 0.
#' @param species_id_length Integer indicating the length of the species IDs.
#' Default: 3.
#' 0: intra- and inter-species (default); 1: intra-species; 2: inter-species
#' @param verbose Logical indicating whether to print progress messages
#' to the screen. Default: FALSE.
#' @references Wang et al. (2012) MCScanX: a toolkit for detection and
#' evolutionary analysis of gene synteny and collinearity.
#' \emph{Nucleic acids research}. \bold{40.7}, e49-e49.
#' @references Haas et al. (2004) DAGchainer: a tool for mining segmental
#' genome duplications and synteny. \emph{Bioinformatics}. \bold{20.18}
#' 3643-3646.
#' @export rcpp_mcscanx_file
#' @author Kristian K Ullrich and Fabricio Almeida-Silva
rcpp_mcscanx_file <- function(blast_file, gff_file, prefix = "out", outdir = "", match_score = 50L, gap_penalty = -1L, match_size = 5L, e_value = 1e-5, max_gaps = 25L, overlap_window = 5L, is_pairwise = FALSE, in_synteny = 0L, species_id_length = 3L, verbose = FALSE) {
    .Call(`_syntenet_rcpp_mcscanx_file`, blast_file, gff_file, prefix, outdir, match_score, gap_penalty, match_size, e_value, max_gaps, overlap_window, is_pairwise, in_synteny, species_id_length, verbose)
}

