\name{systemArgs}
\alias{systemArgs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Constructs SYSargs object from param and targets files
}
\description{
Constructs \code{SYSargs} S4 class objects from two simple tablular files: a
\code{targets} file and a \code{param} file. The latter is optional for
workflow steps lacking command-line software. Typically, a \code{SYSargs}
instance stores all sample-level inputs as well as the paths to the
corresponding outputs generated by command-line- or R-based software generating
sample-level output files. Each sample level input/outfile operation uses its
own \code{SYSargs} instance. The outpaths of \code{SYSargs} usually define the
sample inputs for the next \code{SYSargs} instance. This connectivity is
established by writing the outpaths with the \code{writeTargetsout} function to a
new targets file that serves as input to the next \code{systemArgs} call. By
chaining several \code{SYSargs} steps together one can construct complex
workflows involving many sample-level input/output file operations with any
combinaton of command-line or R-based software.
}
\usage{
systemArgs(sysma, mytargets, type = "SYSargs")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sysma}{ path to 'param' file; file structure follows a simple name/value syntax that
	converted into JSON format; for details about the file structure see sample files provided
	by package. Assign \code{NULL} to run the pipeline without 'param' file. This 
        can be useful for running partial workflows, e.g. with pregenerated BAM files.
}
  \item{mytargets}{ path to targets file
}
  \item{type}{ \code{type="SYSargs"} returns \code{SYSargs}, \code{type="json"} returns param file 
		content in JSON format (requires \code{rjson} library)
}
}
\value{
\code{SYSargs} object or \code{character} string in JSON format
}
\author{
Thomas Girke
}
\seealso{
\code{showClass("SYSargs")}
}
\examples{
## Construct SYSargs object from param and targets files 
param <- system.file("extdata", "tophat.param", package="systemPipeR")
targets <- system.file("extdata", "targets.txt", package="systemPipeR")
args <- systemArgs(sysma=param, mytargets=targets)
args
names(args); modules(args); cores(args); outpaths(args); sysargs(args)

\dontrun{
## Execute SYSargs on single machine
runCommandline(args=args)

## Execute SYSargs on multiple machines of a compute cluster
resources <- list(walltime=120, ntasks=1, ncpus=cores(args), memory=1024) 
reg <- clusterRun(args, conffile=".batchtools.conf.R", template="batchtools.slurm.tmpl", Njobs=18, runid="01", resourceList=resources)

## Monitor progress of submitted jobs
getStatus(reg=reg)
file.exists(outpaths(args))
sapply(1:length(args), function(x) loadResult(reg, x)) # Works once all jobs have completed successfully.

## Alignment stats
read_statsDF <- alignStats(args) 
write.table(read_statsDF, "results/alignStats.xls", row.names=FALSE, quote=FALSE, sep="\t")

## Write outpaths to new targets file for next SYSargs step
writeTargetsout(x=args, file="default")
}
}
\keyword{utilities}
