#' @title 
#' tRNAscanImport: Importing tRNAscan-SE output as GRanges
#' 
#' @author Felix G M Ernst [aut]
#' 
#' @description
#' tRNAscan-SE can be used for prediction of tRNA genes in whole
#' genomes based on sequence context and calculated structural features. Many tRNA
#' annotations in genomes contain or are based on information generated by
#' tRNAscan-SE, for example the current SGD reference genome sacCer3 for
#' Saccharomyces cerevisiae. However, not all available information from
#' tRNAscan-SE end up in the genome annotation. Among these are for example
#' structural information, additional scores and the information, whether the
#' conserved CCA-end is encoded in the genomic DNA. To work with this complete set
#' of information, the tRNAscan-SE output can be parsed into a more accessible
#' GRanges object using `tRNAscanImport`.
#' 
#' @section Manual:
#' Please refer to the tRNAscanImport vignette for an example how to work and 
#' use the package: \href{../doc/tRNAscanImport.html}{tRNAscanImport} 
#'
#' @references 
#' Chan, Patricia P., and Todd M. Lowe. 2016. “GtRNAdb 2.0: An Expanded Database
#' of Transfer Rna Genes Identified in Complete and Draft Genomes.” Nucleic
#' Acids Research 44 (D1): D184–189.. doi:10.1093/nar/gkv1309.
#'
#' Lowe, T. M., and S. R. Eddy. 1997. “TRNAscan-Se: A Program for Improved
#' Detection of Transfer Rna Genes in Genomic Sequence.” Nucleic Acids Research
#' 25 (5): 955–964. 
#'
#' @docType package
#' @name tRNAscanImport
NULL

#' @import methods
#' @import GenomicRanges
#' @import Biostrings
#' @import Structstrings
#' @import tRNA
NULL
requireNamespace("tRNA")

# constants tRNAscanImport -----------------------------------------------------

TRNASCAN_FEATURES <- c(
  tRNA:::TRNA_FEATURES,
  "tRNA_anticodon.start",
  "tRNA_anticodon.end",
  "tRNAscan_score",
  "tRNAscan_potential.pseudogene",
  "tRNAscan_intron.start",
  "tRNAscan_intron.end",
  "tRNAscan_intron.locstart",
  "tRNAscan_intron.locend",
  "tRNAscan_hmm.score",
  "tRNAscan_sec.str.score",
  "tRNAscan_infernal"
)
