% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dar.R
\name{dar}
\alias{dar}
\alias{dar,GRangesList,matrix-method}
\title{Calculate Differential Allelic Representation (DAR)}
\usage{
dar(props, contrasts, region_fixed = NULL, region_loci = NULL)

\S4method{dar}{GRangesList,matrix}(props, contrasts, region_fixed = NULL, region_loci = NULL)
}
\arguments{
\item{props}{\code{GRangesList} containing a summary of normalised allele counts
(i.e. as proportions) at each range.
Each element of the list represents a distinct sample group.}

\item{contrasts}{Contrast \code{matrix} specifying which sample groups to
to calculate DAR between.
Each column must represent a single contrast, and rows represent the levels
(i.e. sample groups) to be contrasted.
The two levels involved with each contrast should be specified with
\code{1} and \code{-1}.}

\item{region_fixed}{\code{integer(1)} specifying the width (in base pairs) of a
fixed sliding window used for averaging DAR values within a region, which is
centralised around the origin.
Must be an integer greater than 1.
This argument takes precedence over \code{region_loci}.}

\item{region_loci}{\code{integer(1)} specifying the number of loci to include
in an elastic sliding window used for averaging DAR values within a region.
Must be an odd integer in order to incorporate the origin locus and an
equal number of loci either side.
Only used when \code{region_fixed} is NULL.}
}
\value{
\code{GRangesList} containing DAR values at each overlapping range
between the contrasted sample groups.
Two types of DAR values are reported in the metadata columns of each GRanges
object:
\itemize{
\item \code{dar_origin}: The raw DAR values calculated at single nucleotide positions
(the origin) between sample groups.
These values represent DAR estimates at a precise locus.
\item \code{dar_region}: The mean of raw DAR values in a specified region surrounding
the origin.
This is optionally returned using either of the \code{region_fixed} or
\code{region_loci} arguments, which control the strategy and size for
establishing regions (more information below).
This option exists because eQTLs don't necessarily confer their effects on
genes in close proximity.
Therefore, DAR estimates that are representative of regions may be more
suitable for downstream assignment DAR values to genomic features.
}

Each element of the list represents a single contrast defined in the
input contrast matrix.
}
\description{
Calculate DAR between two sample groups.
}
\details{
DAR is calculated as the Euclidean distance between the allelic
proportions (i.e. proportion of As, Cs, Gs and Ts) of two sample groups at
a single nucleotide locus, scaled such that all values range inclusively
between 0 and 1.
A DAR value of 0 represents identical allelic representation between the
two sample groups, while a DAR value of 1 represents complete diversity.
}
\examples{
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
props <- countsToProps(counts_filt)
contrasts <- matrix(
    data = c(1, -1),
    dimnames = list(
        Levels = c("group1", "group2"),
        Contrasts = c("group1v2")
    )
)
dar(props, contrasts, region_loci = 5)

}
