% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadar-package.R
\docType{package}
\name{tadar-package}
\alias{tadar}
\alias{tadar-package}
\title{tadar: A package for Differential Allelic Representation (DAR) analysis}
\description{
This package enables DAR analysis by providing functions that address
discrete steps of the analysis workflow.

DAR analysis is intended to be performed using functions in the following
order:
\enumerate{
\item \code{\link[=readGenotypes]{readGenotypes()}} parses a multi-sample VCF file and returns a \code{GRanges}
object containing only the data that is required for DAR analysis.
\item \code{\link[=countAlleles]{countAlleles()}} summarises the alleles from genotype data at each range
for each sample group.
\item \code{\link[=filterLoci]{filterLoci()}} removes ranges that do not match a specified criterion.
\item \code{\link[=countsToProps]{countsToProps()}} normalises the allele counts to account for missing
data and sample groups of different sizes.
\item \code{\link[=dar]{dar()}} calculates the DAR between two sample groups.
\item \code{\link[=flipRanges]{flipRanges()}} is an optional step that enables the conversion of ranges
output by \code{\link[=dar]{dar()}} from origins to regions, or vice versa.
\item \code{\link[=assignFeatureDar]{assignFeatureDar()}} assigns DAR values to features of interest.
}

\code{tadar} also provides visualisation functions that allow quick inspection
of DAR within the dataset:
\itemize{
\item \code{\link[=plotChrDar]{plotChrDar()}} produces a \code{Gviz} plot that displays the trend in DAR across
a chromosome.
\item \code{\link[=plotDarECDF]{plotDarECDF()}} produces a \code{ggplot2} figure comparing DAR between
chromosomes.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/baerlachlan/tadar}
  \item Report bugs at \url{https://github.com/baerlachlan/tadar/issues}
}

}
\author{
Lachlan Baer, Stevie Pederson
}
\keyword{internal}
