% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{direct_targets}
\alias{direct_targets}
\title{Predict direct targets}
\usage{
direct_targets(peaks, regions, regions_col, stats_col, base = 1e+05)
}
\arguments{
\item{peaks}{A GRanges object}

\item{regions}{A GRanges object}

\item{regions_col}{A character string}

\item{stats_col}{A character string}

\item{base}{An integer to calculate distances relative to.}
}
\value{
A GRanges object. A similar object to regions with several added
metadata columns.
}
\description{
This function selects overlapping peaks and regions, calculates the distance
between them, score each peak and region and calculate rank products of the
regions.
}
\examples{
# load peaks and transcripts data
data("real_peaks")
data("real_transcripts")

# direct targets
dt <- direct_targets(real_peaks, real_transcripts, 'name2', 't')

}
