% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{score_peaks}
\alias{score_peaks}
\title{Calculate peak scores}
\usage{
score_peaks(distance, base)
}
\arguments{
\item{distance}{A vector of integers}

\item{base}{An integer to calculate distances relative to.}
}
\value{
A vector of integers
}
\description{
Calculate the peak score based on the distance to a region of interest.
}
\examples{
library(IRanges)

query <- IRanges(c(1, 4, 9), c(5, 7, 10))
subject <- IRanges(c(2, 2, 10), c(2, 3, 12))
distance <- find_distance(query, subject)
score_peaks(distance, 100000)

}
