% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAdata.R
\name{getAssayTable}
\alias{getAssayTable}
\title{Obtain a reference table for assay data in the Terra data model}
\usage{
getAssayTable(
  tablename = .DEFAULT_TABLENAME,
  metacols = .PARTICIPANT_METADATA_COLS,
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE
)
}
\arguments{
\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{metacols}{The set of columns that comprise of the metadata columns.
See the \code{.PARTICIPANT_METADATA_COLS} global variable}

\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}
}
\value{
A tibble of pointers to resources within the Terra data model
}
\description{
The column names in the output can be used in the \code{getAssayData} function.
}
\examples{
if (
    GCPtools::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
)
  getAssayTable(workspace = "TCGA_COAD_OpenAccess_V1-0_DATA")

}
