% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibble-AggregatedCoverage}
\alias{as_tibble-AggregatedCoverage}
\alias{as_tibble.AggregatedCoverage}
\title{as_tibble}
\usage{
\method{as_tibble}{AggregatedCoverage}(x, ...)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that could reasonably be
coerced to a tibble.}

\item{...}{Unused, for extensibility.}
}
\value{
\code{tibble}
}
\description{
Coerce an \code{CoverageExperiment} or \code{AggregatedCoverage} object into a \code{tibble}
}
\section{Row names}{


The default behavior is to silently remove row names.

New code should explicitly convert row names to a new column using the
\code{rownames} argument.

For existing code that relies on the retention of row names, call
\code{pkgconfig::set_config("tibble::rownames" = NA)} in your script or in your
package's \code{\link[=.onLoad]{.onLoad()}}  function.

}

\section{Life cycle}{


Using \code{as_tibble()} for vectors is superseded as of version 3.0.0,
prefer the more expressive \code{as_tibble_row()} and
\code{as_tibble_col()} variants for new code.

}

\examples{
data(ac)
as_tibble(ac)
}
\seealso{
\code{\link[tibble:tibble]{tibble()}} constructs a tibble from individual columns. \code{\link[tibble:enframe]{enframe()}}
converts a named vector to a tibble with a column of names and column of
values. Name repair is implemented using \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
}
