% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbml_as_list.R
\name{sbml_as_list}
\alias{sbml_as_list}
\title{Create R list from sbml file}
\usage{
sbml_as_list(file, component = "all")
}
\arguments{
\item{file}{path for the sbml file to be loaded}

\item{component}{description of which entities (i.e. sbml level) have to be extracted into a list, a character string}
}
\value{
sbml converted into a R list
}
\description{
This function converts a sbml file into a R list.
}
\details{
By selecting the argument 'component' as 'all' it returns the sbml-converted list looking at the highest level (i.e. 'sbml' tag), whereas if it equals either 'species', 'reactions' or 'compartments', the list can be restricted to the species/reactions/compartments level.
The first option permits to use the resulting list as input for as_dfs() function, while the other options provide the input for as_df() function.
}
\examples{
filepath <- system.file("extdata", "R-HSA-8937144.sbml", package = "tidysbml")

sbml_list <- sbml_as_list(filepath, "all") ## returns the R list with the entire sbml model

sbml_as_list(filepath, "species") ## returns the R list restricted to the list of species

sbml_as_list(filepath, "reactions") ## returns the R list restricted to the list of reactions

sbml_as_list(filepath, "compartments") ## returns the R list restricted to the list of components
}
