% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-AbstractTopDownSet.R
\docType{class}
\name{AbstractTopDownSet-class}
\alias{AbstractTopDownSet-class}
\alias{[,AbstractTopDownSet,ANY,ANY,ANY-method}
\alias{[[,AbstractTopDownSet,ANY,missing-method}
\alias{[[,AbstractTopDownSet,ANY,missing,-method}
\alias{[[<-,AbstractTopDownSet,ANY,missing-method}
\alias{[[<-,AbstractTopDownSet,ANY,missing,-method}
\alias{$,AbstractTopDownSet-method}
\alias{$<-,AbstractTopDownSet-method}
\alias{assayData,AbstractTopDownSet-method}
\alias{colData,AbstractTopDownSet-method}
\alias{colData}
\alias{colData<-,AbstractTopDownSet-method}
\alias{colData<-}
\alias{combine,AbstractTopDownSet,AbstractTopDownSet-method}
\alias{combine}
\alias{conditionData,AbstractTopDownSet-method}
\alias{conditionData}
\alias{conditionData<-,AbstractTopDownSet-method}
\alias{conditionData<-}
\alias{conditionNames,AbstractTopDownSet-method}
\alias{conditionNames}
\alias{dim,AbstractTopDownSet-method}
\alias{dimnames,AbstractTopDownSet-method}
\alias{removeEmptyConditions,AbstractTopDownSet-method}
\alias{removeEmptyConditions}
\alias{rowViews,AbstractTopDownSet-method}
\alias{rowViews}
\alias{show,AbstractTopDownSet-method}
\alias{summary,AbstractTopDownSet-method}
\alias{updateConditionNames,AbstractTopDownSet-method}
\alias{updateConditionNames}
\alias{updateMedianInjectionTime,AbstractTopDownSet-method}
\alias{updateMedianInjectionTime}
\alias{updateMedianInjectionTime,TopDownSet-method}
\title{The AbstractTopDownSet class}
\usage{
\S4method{[}{AbstractTopDownSet,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[[}{AbstractTopDownSet,ANY,missing}(x, i, j, ...)

\S4method{[[}{AbstractTopDownSet,ANY,missing}(x, i, j, ...) <- value

\S4method{$}{AbstractTopDownSet}(x, name)

\S4method{$}{AbstractTopDownSet}(x, name) <- value

\S4method{assayData}{AbstractTopDownSet}(object)

\S4method{colData}{AbstractTopDownSet}(object)

\S4method{colData}{AbstractTopDownSet}(object, ...) <- value

\S4method{combine}{AbstractTopDownSet,AbstractTopDownSet}(x, y)

\S4method{conditionData}{AbstractTopDownSet}(object, ...)

\S4method{conditionData}{AbstractTopDownSet}(object, ...) <- value

\S4method{conditionNames}{AbstractTopDownSet}(object)

\S4method{dim}{AbstractTopDownSet}(x)

\S4method{dimnames}{AbstractTopDownSet}(x)

\S4method{removeEmptyConditions}{AbstractTopDownSet}(object)

\S4method{rowViews}{AbstractTopDownSet}(object, ...)

\S4method{show}{AbstractTopDownSet}(object)

\S4method{summary}{AbstractTopDownSet}(object, what = c("rows", "columns"), ...)

\S4method{updateConditionNames}{AbstractTopDownSet}(
  object,
  sampleColumns = c("Mz", "AgcTarget", "EtdReagentTarget", "EtdActivation",
    "CidActivation", "HcdActivation", "UvpdActivation"),
  verbose = interactive()
)

\S4method{updateMedianInjectionTime}{AbstractTopDownSet}(
  object,
  by = list(Mz = object$Mz, AgcTarget = object$AgcTarget)
)
}
\arguments{
\item{i, j}{\code{numeric}, \code{logical} or \code{character},
indices specifying elements to extract or replace.}

\item{drop}{\code{logical}, currently ignored.}

\item{value}{replacment value.}

\item{name}{\code{character} name of an (non)existing column in \code{colData}.}

\item{object, x}{\code{AbstractTopDownSet}}

\item{y}{\code{AbstractTopDownSet}}

\item{what}{\code{character},
specifies whether \code{"rows"} or \code{"columns"} should be summarized.}

\item{sampleColumns}{\code{character},
column names of the \code{\link[=colData]{colData()}}
used to define a sample (technical replicate). This is used to add the
\code{Sample} column (used for easier aggregation, etc.).}

\item{verbose}{\code{logical}, verbose output?}

\item{by}{\code{list}, grouping information.}

\item{\ldots}{arguments passed to internal/other methods.}
}
\value{
This is an \emph{Abstract/VIRTUAL} class
to provide a common interface for
\linkS4class{TopDownSet} and \linkS4class{NCBSet}.
It is not possible to create an \code{AbstractTopDownSet} object.
}
\description{
\emph{Abstract/VIRTUAL} parent class for
\linkS4class{TopDownSet} and \linkS4class{NCBSet} to provide common interface.
}
\details{
This class just provides a common interface. It is not intended for direct
use by the user. Please see \linkS4class{TopDownSet} for an example usage of its
child class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{x[i}: Subset operator.

For \code{i} \code{numeric}, \code{logical} or \code{character} vectors or empty
(missing) or \code{NULL} are supported.
Subsetting is done on the fragment/bond (row) level.
\code{character} indices could be names
(e.g. \code{c("a1", "b1", "c1", "c2", "c3")})
or types (e.g. \code{c("c", "x")}) of the fragments for
\linkS4class{TopDownSet} objects,
or names of the bonds (e.g. \code{c("bond001")}) for
\linkS4class{NCBSet} objects. \cr
\code{j} could be a \code{numeric} or \code{logical} vector
and subsetting is done on the condition/run (column) level.

\item \code{x[[i}: Subset operator.

\code{i} could be a \code{numeric} or \code{logical} vector and
subsetting is done on the condition/run (column) level.

\item \code{`[[`(x = AbstractTopDownSet, i = ANY, j = missing) <- value}: Setter for a column in the \code{colData} slot.

The \verb{[[<-} operator is used to add/replace
a single column of the \code{colData} \code{DataFrame}.

\item \code{$}: Accessor for columns in the \code{colData} slot.

The \code{$} simplifies the accession of a single column
of the \code{colData}.
It is identical to the \code{[[} operator.

\item \code{`$`(AbstractTopDownSet) <- value}: Setter for a column in the \code{colData} slot.

The \verb{$<-} operator is used to add/replace a single column
of the \code{colData} \code{DataFrame}.
It is identical to the \verb{[[<-} operator.

\item \code{assayData(AbstractTopDownSet)}: Accessor for the \code{assay} slot.

Returns a \link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix} that stores the
intensity/coverage information of \linkS4class{AbstractTopDownSet}
object.

\item \code{colData(AbstractTopDownSet)}: Accessor for the \code{colData} slot.

Returns a \link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame} that stores
metadata for the conditons/runs (columns) of the
\linkS4class{AbstractTopDownSet} object.

\item \code{colData(AbstractTopDownSet) <- value}: Setter for the \code{colData} slot.

Replaces metadata for the conditons/runs (columns) of the
\linkS4class{AbstractTopDownSet} object.

\item \code{combine(x = AbstractTopDownSet, y = AbstractTopDownSet)}: Combine \code{AbstractTopDownSet} objects.

\code{combine} allows to combine two or more \code{AbstractTopDownSet} objects.
Please note that it uses the default
\code{sampleColumns} to define technical replicates (see \code{\link[=readTopDownFiles]{readTopDownFiles()}}).and
the default \code{by} argument to group ion injection times for the calculation of
the median time (see \code{\link[=updateMedianInjectionTime]{updateMedianInjectionTime()}}). Both could be modified
after \code{combine} by calling \code{\link[=updateConditionNames]{updateConditionNames()}} (with modified
\code{sampleColumns} argument) and \code{\link[=updateMedianInjectionTime]{updateMedianInjectionTime()}} (with modified
\code{by} argument).

\item \code{conditionData(AbstractTopDownSet)}: Accessor for the \code{colData} slot.

An alias for \code{colData}.

\item \code{conditionData(AbstractTopDownSet) <- value}: Setter for the \code{colData} slot.

An alias for \verb{colData<-}.

\item \code{conditionNames(AbstractTopDownSet)}: Accessor for condition names.

Returns a \code{character} with names for the conditions/runs (columns).

\item \code{dim(AbstractTopDownSet)}: Accessor for dimensions.

Returns a \code{numeric} with number of fragments/bonds (rows) and
conditions/runs (columns).

\item \code{dimnames(AbstractTopDownSet)}: Accessor for dimension names.

Returns a \code{list} with names for the fragments/bonds (rows) and for the
conditions/runs (columns).

\item \code{removeEmptyConditions(AbstractTopDownSet)}: Remove empty conditions/runs.

Removes conditions/runs (columns) without any intensity/coverage
information from the \linkS4class{AbstractTopDownSet} object.
It returns a modified \linkS4class{AbstractTopDownSet} object.

\item \code{rowViews(AbstractTopDownSet)}: Accessor for the \code{rowViews} slot.

Depending on the implementation it returns an
\linkS4class{FragmentViews} object for
\linkS4class{TopDownSet} objects
or an \link[Biostrings:XStringViews-class]{Biostrings::XStringViews} object for
\linkS4class{NCBSet} objects.

\item \code{summary(AbstractTopDownSet)}: Summary statistics.

Returns a \code{matrix} with some statistics: number of fragments,
total/min/first quartile/median/mean/third quartile/maximum of intensity
values.

\item \code{updateConditionNames(AbstractTopDownSet)}: Update condition names.

Updates condition names based on \code{sampleColumns} from
\code{conditionData}/\code{colData}. Columns with just identical entries are ignored.
This method will create/update the \code{colData(object)$Sample} column that
identifies technical replicates and could be used in other methods.

\item \code{updateMedianInjectionTime(AbstractTopDownSet)}: Update median ion injection times.

Recalculates median ion injection times by a user given grouping variable
(default: Mz, AgcTarget). This is useful if you acquire new data and the ion
injection time differs across the runs. Use the \code{by} argument to provide a
\code{list}/\code{data.frame} of grouping variables, e.g.
\code{by=colData(object)[, c("Mz", "AgcTarget", "File")]}.

}}
\section{Slots}{

\describe{
\item{\code{rowViews}}{\link[Biostrings:XStringViews-class]{Biostrings::XStringViews},
information about fragments/bonds (name, type, sequence, mass, charge),
see \link[Biostrings:XStringViews-class]{Biostrings::XStringViews} and
\linkS4class{FragmentViews} for details.}

\item{\code{colData}}{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame},
information about the MS2 experiments and the fragmentation conditions.}

\item{\code{assay}}{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix},
intensity/coverage values of the fragments/bonds.
The rows correspond to the fragments/bonds and the
columns to the condition/run. It just stores values that are
different from zero.}

\item{\code{files}}{\code{character}, files that were imported.}

\item{\code{processing}}{\code{character}, log messages.}
}}

\examples{
## Because AbstractTopDownSet is a VIRTUAL class we could not create any
## object of it. Here we demonstrate the usage with an TopDownSet that
## implements the AbstractTopDownSet interface. See `?"TopDownSet-class"` for
## more details an further examples.

## Example data
data(tds, package="topdownr")

tds

head(summary(tds))

# Accessing slots
rowViews(tds)
colData(tds)
head(assayData(tds))

# Accessing colData
tds$Mz
tds$FilterString

# Subsetting

# First 100 fragments
tds[1:100]

# All c fragments
tds["c"]

# Just c 152
tds["c152"]

# Condition 1 to 10
tds[, 1:10]
}
\seealso{
\itemize{
\item \linkS4class{TopDownSet} and \linkS4class{NCBSet}
which both implement/use this interface.
These manual pages also provide some example code.
\item \linkS4class{FragmentViews}
(and \link[Biostrings:XStringViews-class]{Biostrings::XStringViews})
for the row view interface.
\item \link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}
for technical details about the intensity/coverage storage.
}
}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de}
}
