% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment-functions.R
\name{validMs1Settings}
\alias{validMs1Settings}
\alias{validTms2Settings}
\title{List valid MS settings.}
\usage{
validMs1Settings(family = "Calcium", version = "3.2")

validTms2Settings(
  type = c("All", "TMS2", "ETD", "CID", "HCD", "UVPD"),
  family = "Calcium",
  version = "3.2"
)
}
\arguments{
\item{family}{\code{character}, currently just Calcium is supported}

\item{version}{\code{character}, currently 3.1, 3.2 (default), 3.3 are supported}

\item{type}{\code{character}, type of activation.}
}
\value{
\code{matrix} with three columns:
\itemize{
\item name: element name
\item class: expected R class of the value
\item type: MS/ActivationType, e.g. MS1/TMS2/ETD/...
}
}
\description{
These functions list settings for MS1 or TMS2 that are supported by
\emph{Thermo's XmlMethodChanger}.
}
\examples{
validMs1Settings()
validTms2Settings()
validTms2Settings("TMS2")
validTms2Settings("ETD")
validTms2Settings(c("TMS2", "ETD"))
}
