% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{ggplot.well}
\alias{ggplot.well}
\alias{ggplot.wells}
\alias{ggplot.plate}
\alias{ggplot.multiwell}
\alias{ggplot.well,ddpcrWell-method}
\alias{ggplot.plate,ddpcrPlate-method}
\title{ggplot methods for the \code{\link{ddpcrWell}} and
\code{\link{ddpcrPlate}} classes.}
\usage{
ggplot.well(
  data,
  mapping = aes_string(x = "Ch2.Amplitude", y = "Ch1.Amplitude", colour = cMethod),
  cMethod = NULL,
  ...,
  environment = parent.frame()
)

\S4method{ggplot.well}{ddpcrWell}(
  data,
  mapping = aes_string(x = "Ch2.Amplitude", y = "Ch1.Amplitude", colour = cMethod),
  cMethod = "None",
  ...,
  environment = parent.frame()
)

ggplot.plate(
  data,
  mapping = aes_string(x = "Ch2.Amplitude", y = "Ch1.Amplitude", colour = class),
  cMethod = "None",
  ...,
  environment = parent.frame()
)

\S4method{ggplot.plate}{ddpcrPlate}(
  data,
  mapping = aes_string(x = "Ch2.Amplitude", y = "Ch1.Amplitude", colour = cMethod),
  cMethod = "None",
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{A \code{ddpcrWell} or \code{ddpcrPlate} object.}

\item{mapping}{A list of aesthetic mappings to use for the plot. Defaults to
\code{ggplot2::aes_string(x="Ch2.Amplitude", y="Ch1.Amplitude",
colour=cMethod)}, where \code{cMethod} is taken from the parameter of the
same name.}

\item{cMethod}{The name or column number of the classification to use. This
is renamed internally to "class" for use with \code{mapping}. Defaults to
"None".}

\item{...}{Other arguments passed onto \code{\link[ggplot2]{ggplot}}.}

\item{environment}{Where to look if a mapping variable is not defined.
Defaults to \code{parent.frame()}, i.e. the environment in which
\code{ggplot.well()} or \code{ggplot.multiwell()} is called.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object using the slots in the given
object.
}
\description{
These functions work in the same way as the original
\code{\link[ggplot2]{ggplot}} method, but handles the coercion of the object
into a data frame.

\code{ggplot.well} is a \code{\link[ggplot2]{ggplot}} method
for the \code{\link{ddpcrWell}} class.

\code{ggplot.multiwell} is a \code{\link[ggplot2]{ggplot}}
method for the \code{\link{ddpcrPlate}} class.
}
\examples{
## Plot the droplets in one well.
library(ggplot2)
aWell <- ddpcrWell(KRASdata[["E03"]])
ggplot.well(aWell, cMethod="Cluster") + geom_point()

## Plot the droplets in all of the wells in a single plot.
krasPlate <- ddpcrPlate(KRASdata)
ggplot.plate(krasPlate, cMethod="Cluster") + geom_point()

}
\seealso{
\code{\link{dropletPlot}} builds upon these \code{ggplot} methods
to plot droplet amplitude plots with a colour-blind friendly palette.

The original \code{\link[ggplot2]{ggplot}} method in the
\code{ggplot2} package is used internally.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
