% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCSVDataFrame.R
\name{readCSVDataFrame}
\alias{readCSVDataFrame}
\title{Read all given CSV files into a list.}
\usage{
readCSVDataFrame(path, wellCol = FALSE, sortByLetter = FALSE)
}
\arguments{
\item{path}{The path containing the CSV files (can be a combination of
directories and individual CSV file paths). Each file will have
a \code{Ch1.Amplitude}, \code{Ch2.Amplitude} and possibly classification
columns, e.g. by default, QuantaSoft returns a \code{Cluster} column too.}

\item{wellCol}{If \code{TRUE}, an additional column is added with the well
name.  This is useful if we need to merge all the data in the output list
and we want to identify the original well of each droplet. Defaults to
\code{FALSE}.}

\item{sortByLetter}{If \code{TRUE}, the resulting list is sorted by the
letter in the well names first, e.g. "A02" comes before "B01". If
\code{FALSE}, the result is sorted by the numeric component of the well
names first, e.g. "B01" comes before "A02". Defaults to \code{FALSE}.}
}
\value{
A list of data frames, each containing the data from a CSV file with
the corresponding well name.
}
\description{
Bio-Rad's QuantaSoft can export droplet amplitude data from multiple wells
into CSV files for each well. This function can read these CSV files into
a list. Note that empty wells will be ignored.
}
\examples{
## Read all of the droplet amplitudes from CSV files in a directory.
moreAmpsDir <- system.file("extdata", "more-amplitudes", package="twoddpcr")
someWells <- readCSVDataFrame(moreAmpsDir)

## We can read files from directories and files at the same time.
ampFile <- system.file("extdata", "amplitudes", "sample_B03_Amplitude.csv",
                       package="twoddpcr")
someWells <- readCSVDataFrame(c(moreAmpsDir, ampFile))

## If samples have been ordered by "A01", "A02", "A03", etc. instead of
## "A01", "B01", "C01", etc., we can set the sortByLetter flag to TRUE.
someWells <- readCSVDataFrame(moreAmpsDir, sortByLetter=TRUE)

## Setting wellCol to TRUE adds an extra column with the well name. If we
## bind the data frames together, we can track where the droplets came from.
someWells <- readCSVDataFrame(moreAmpsDir, wellCol=TRUE)
someWells <- do.call(rbind, someWells)
head(someWells)
tail(someWells)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
