% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStratifyBy.R
\name{plotStratifyBy}
\alias{plotStratifyBy}
\title{plotStratifyBy}
\usage{
plotStratifyBy(
  geneExpr,
  xval,
  yval,
  xlab = xval,
  ylab = yval,
  main = NULL,
  sortBy = xval,
  colorBy = xval,
  sort = TRUE,
  text = NULL,
  text.y = 1,
  text.size = 5,
  pts.cex = 1,
  ylim = NULL,
  legend = TRUE,
  x.labels = FALSE
)
}
\arguments{
\item{geneExpr}{data.frame of gene expression values and another variable for each sample.  If there are multiple columns, the user can specify which one to use}

\item{xval}{name of column in geneExpr to be used along x-axis to stratify gene expression}

\item{yval}{name of column in geneExpr indicating gene expression}

\item{xlab}{label x-asis. Defaults to value of xval}

\item{ylab}{label y-asis. Defaults to value of yval}

\item{main}{main label}

\item{sortBy}{name of column in geneExpr to sort samples by.  Defaults to xval}

\item{colorBy}{name of column in geneExpr to color box plots.  Defaults to xval}

\item{sort}{if TRUE, sort boxplots by median value, else use default ordering}

\item{text}{plot text on the top left of the plot}

\item{text.y}{indicate position of the text on the y-axis as a fraction of the y-axis range}

\item{text.size}{size of text}

\item{pts.cex}{size of points}

\item{ylim}{specify range of y-axis}

\item{legend}{show legend}

\item{x.labels}{show x axis labels}
}
\value{
ggplot2 object
}
\description{
Plot gene expression stratified by another variable
}
\examples{

# load library
# library(variancePartition)

# load simulated data:
data(varPartData)

# Create data.frame with expression and Tissue information for each sample
GE <- data.frame(Expression = geneExpr[1, ], Tissue = info$Tissue)

# Plot expression stratified by Tissue
plotStratifyBy(GE, "Tissue", "Expression")

# Omit legend and color boxes grey
plotStratifyBy(GE, "Tissue", "Expression", colorBy = NULL)

# Specify colors
col <- c(B = "green", A = "red", C = "yellow")
plotStratifyBy(GE, "Tissue", "Expression", colorBy = col, sort = FALSE)

}
