#' Data from a typical proteomics experiment
#'
#' There are 12 samples coming from mouse fed with the four different diets, measured in three replicates each. 
#' Relative protein abundances were obtained using iTRAQ labelling. The given numbers are log2-transformed.
#' Protein names as UniProt accession numbers are given as rownames.
#'
#' @docType data
#' @usage data(protein_expressions)
#' @format A data frame consisting of 574 proteins measured in 12 samples:
#' \describe{
#'   \item{HF.Rep.1}{Mice fed with a high fat diet, replicate 1} 
#'   \item{HF.Rep.2}{Mice fed with a high fat diet, replicate 2} 
#'   \item{HF.Rep.3}{Mice fed with a high fat diet, replicate 3} 
#'   \item{TTA.Rep.1}{Mice fed with a diet containing TTA (Tetradecylthioacetic Acid) high fat diet, replicate 1} 
#'   \item{TTA.Rep.2}{Mice fed with a diet containing TTA (Tetradecylthioacetic Acid) high fat diet, replicate 2} 
#'   \item{TTA.Rep.3}{Mice fed with a diet containing TTA (Tetradecylthioacetic Acid) high fat diet, replicate 3} 
#'   \item{FO.Rep.1}{Mice fed with a fish oil diet, replicate 1} 
#'   \item{FO.Rep.2}{Mice fed with a fish oil diet, replicate 2} 
#'   \item{FO.Rep.3}{Mice fed with a fish oil diet, replicate 3} 
#'   \item{TTA.FO.Rep.1}{Mice fed with a diet containing fish oil and TTA, replicate 1} 
#'   \item{TTA.FO.Rep.2}{Mice fed with a diet containing fish oil and TTA, replicate 2} 
#'   \item{TTA.FO.Rep.3}{Mice fed with a diet containing fish oil and TTA, replicate 3} 
#' }
#' @source Protein Research Group, University of Southern Denmark, Odense
"protein_expressions"
