% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareData.R
\name{SignAnalysis}
\alias{SignAnalysis}
\title{Unpaired statistical testing}
\usage{
SignAnalysis(Data, NumCond, NumReps)
}
\arguments{
\item{Data}{a numeric data matrix with columns as samples. Different 
experimental conditions are grouped together in their replicates. The number 
of samples per group needs to be identical}

\item{NumCond}{Number of different experimental conditions}

\item{NumReps}{Number of replicates per experimental condition}
}
\value{
List containing the objects

`pvalues` p-values before correction for multiple testing

`qvalues` false discovery rates after correction for multiple testing 
(`qvalue` method from `qvalue` library)

`Sds` General standard deviation within replicates after using 
shrinkage by LIMMA
}
\description{
Statistical testing and variance estimation in multi-dimensional data set. 
given by a matrix. This functions runs LIMMA paired tests and
calculated the shrunken variance estimates.
}
\examples{
#' # Generate some random data
data <- matrix(rnorm(seq_len(1000)), nrow=100)
# Run statistical testing
stat_out <- SignAnalysis(data, 2, 5)
# Histogram of qvalues (no significant events)
hist(stat_out$qvalues, 50, xlab="q-values")
}
\references{
Schwaemmle V, Jensen ON. VSClust: feature-based variance-sensitive clustering 
of omics data. Bioinformatics. 2018 Sep 1;34(17):2965-2972. doi: 
10.1093/bioinformatics/bty224. PMID: 29635359.

Schwaemmle V, Hagensen CE. A Tutorial for Variance-Sensitive Clustering and 
the Quantitative Analysis of Protein Complexes. Methods Mol Biol. 
2021;2228:433-451. doi: 10.1007/978-1-0716-1024-4_30. PMID: 33950508.

Schwaemmle V, Jensen ON. A simple and fast method to determine the parameters 
for fuzzy c-means cluster analysis. Bioinformatics. 2010 
Nov 15;26(22):2841-8. doi: 10.1093/bioinformatics/btq534. Epub 2010 Sep 29. 
PMID: 20880957.
}
