% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annot_functions.R
\name{filter_annot_with_network}
\alias{filter_annot_with_network}
\title{Filter ontology datasets using PPI network object}
\usage{
filter_annot_with_network(data_annot, graph_op)
}
\arguments{
\item{data_annot}{Data frame (tibble) of GO or HPO datasets from
\code{\link{wppi_go_data}} or \code{\link{wppi_hpo_data}}.}

\item{graph_op}{Igraph graph object obtained from built OmniPath PPI of
genes of interest and x-degree neighbors.}
}
\value{
Data frame (tibble) of GO or HPO datasets filtered based on
    proteins available in the igraph object.
}
\description{
Filter ontology datasets using PPI network object
}
\examples{
# Get GO database
GO_data <- wppi_go_data()
# Create igraph object based on genes of interest and first neighbors
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
graph_op <- graph_from_op(wppi_omnipath_data())
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
# Filter GO data
GO_data_filtered <- filter_annot_with_network(GO_data, graph_op_1)

}
\seealso{
\itemize{
    \item{\code{\link{wppi_go_data}}}
    \item{\code{\link{wppi_hpo_data}}}
    \item{\code{\link{graph_from_op}}}
}
}
