% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{random_walk}
\alias{random_walk}
\title{Random Walk with Restart (RWR)}
\usage{
random_walk(weighted_adj_matrix, restart_prob = 0.4, threshold = 1e-05)
}
\arguments{
\item{weighted_adj_matrix}{Matrix object corresponding to the weighted
adjacency from \code{\link{weighted_adj}}.}

\item{restart_prob}{Positive value between 0 and 1 defining the restart
probability parameter used in the RWR algorithm. If not specified, 0.4
is the default value.}

\item{threshold}{Positive value depicting the threshold parameter in the
RWR algorithm. When the error between probabilities is smaller than the
threshold defined, the algorithm stops. If not specified, 1e-5 is
the default value.}
}
\value{
Matrix of correlation/probabilities for the functional
    similarities for all proteins/genes in the network.
}
\description{
RWR on the normalized weighted adjacency matrix.
The RWR algorithm estimates each protein/gene relevance based on the
functional similarity of genes and disease/phenotype, and the topology
of the network. This similarity score between nodes measures how closely
two proteins/genes are related in a network. Thus, enabling to identify
which candidate genes are more related to our given genes of interest.
}
\examples{
db <- wppi_data()
GO_data <- db$go
HPO_data <- db$hpo
# Genes of interest
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
# Graph object with PPI 
graph_op <- graph_from_op(db$omnipath)
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
# Filter ontology data
GO_data_filtered <- filter_annot_with_network(GO_data, graph_op_1)
HPO_data_filtered <- filter_annot_with_network(HPO_data, graph_op_1)
# Weighted adjacency
w_adj <- weighted_adj(graph_op_1, GO_data_filtered, HPO_data_filtered)
# Random Walk with Restart
w_rw <- random_walk(w_adj)

}
\seealso{
\itemize{
    \item{\code{\link{weighted_adj}}}
    \item{\code{\link{prioritization_genes}}}
    \item{\code{\link{score_candidate_genes_from_PPI}}}
}
}
