% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcode.R
\name{ggprepSeg}
\alias{ggprepSeg}
\title{prepare a XenSPEP for ggplot2 visualization}
\usage{
ggprepSeg(xsce, xlim = c(5800, 6200), ylim = c(6300, 6700))
}
\arguments{
\item{xsce}{XenSPEP instance}

\item{xlim}{numeric(2)}

\item{ylim}{numeric(2)}
}
\value{
a list with components `bounds` (data.frame including relevant colData
rows (all colData variables) and cell boundary coordinates) and `txdata`, a filtered
arrow Table.
}
\description{
prepare a XenSPEP for ggplot2 visualization
}
\note{
This is idiosyncratic.  Quintiles of cell_area (values in `sizq`) are produced, and transcript locations
are filtered.  A more general approach that allows selection of coloring
of cells by feature characteristics is needed.
}
\examples{
pa <- cacheXenLuad()
luad <- restoreZipXenSPEP(pa)
hh <- ggprepSeg(luad, c(4000, 4500), c(2000, 2500))
ggplot2::ggplot(hh$bounds, ggplot2::aes(
  x = vertex_x, y = vertex_y, group = cell_id,
  colour = sizq, fill = sizq
)) +
  ggplot2::geom_polygon(alpha = .5)
}
