% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkTissuesToMerge.R
\name{checkTissuesToMerge}
\alias{checkTissuesToMerge}
\title{Check tissues to merge based on gene expression profile}
\usage{
checkTissuesToMerge(obj, majorGroups, minorGroups, filterFun = NULL,
  plotFlag = TRUE, ...)
}
\arguments{
\item{obj}{ExpressionSet object.}

\item{majorGroups}{Column name in the phenoData slot that describes the general body region or site of the sample.}

\item{minorGroups}{Column name in the phenoData slot that describes the specific body region or site of the sample.}

\item{filterFun}{Filter group specific genes that might disrupt PCoA analysis.}

\item{plotFlag}{TRUE/FALSE whether to plot or not}

\item{...}{Parameters that can go to \code{\link[yarn]{checkMisAnnotation}}}
}
\value{
CMDS Plots of the majorGroupss colored by the minorGroupss. Optional matrix of CMDS loadings for each comparison.
}
\description{
Check tissues to merge based on gene expression profile
}
\examples{
data(skin)
checkTissuesToMerge(skin,'SMTS','SMTSD')

}
\seealso{
checkTissuesToMerge
}
