% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validateH5ADSCE}
\alias{validateH5ADSCE}
\title{Validate H5AD SCE}
\usage{
validateH5ADSCE(sce, names, missing)
}
\arguments{
\item{sce}{A \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} object.}

\item{names}{Named list of expected names. Names are slots and values are
vectors of names that are expected to exist in that slot.}

\item{missing}{Named list of known missing names. Names are slots and values
are vectors of names that are expected to not exist in that slot.}
}
\value{
If checks are successful \code{TRUE} invisibly, if not other output
depending on the context
}
\description{
Validate a SingleCellExperiment created by \code{readH5AD()}. Designed to be used
inside \code{testhat::test_that()} during package testing.
}
\details{
This function checks that a SingleCellExperiment contains the expected items
in each slot. The main reason for this function is avoid repeating code when
testing multiple \code{.h5ad} files. The following items in \code{names} and \code{missing}
are recognised:
\itemize{
\item \code{assays} - Assay names
\item \code{colData} - colData column names
\item \code{rowData} - rowData column names
\item \code{metadata} - metadata names
\item \code{redDim} - Reduced dimension names
\item \code{varm} - Column names of the \code{varm} rowData column (from the AnnData varm
slot)
\item \code{colPairs} - Column pair names
\item \code{rowPairs} - rowData pair names
\item \code{raw_rowData} - rowData columns names in the \code{raw} altExp
\item \code{raw_varm} - Column names of the raw \code{varm} rowData column (from the
AnnData varm slot)
}

If an item in \code{names} or \code{missing} is \code{NULL} then it won't be checked. The
items in \code{missing} are checked that they explicitly do not exist. This is
mostly for record keeping when something is known to not be converted but can
also be useful when the corresponding \code{names} item is \code{NULL}.
}
\author{
Luke Zappia
}
