% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_methods.R
\name{zinbModel}
\alias{zinbModel}
\title{Initialize an object of class ZinbModel}
\usage{
zinbModel(
  X,
  V,
  O_mu,
  O_pi,
  which_X_mu,
  which_X_pi,
  which_V_mu,
  which_V_pi,
  W,
  beta_mu,
  beta_pi,
  gamma_mu,
  gamma_pi,
  alpha_mu,
  alpha_pi,
  zeta,
  epsilon,
  epsilon_beta_mu,
  epsilon_gamma_mu,
  epsilon_beta_pi,
  epsilon_gamma_pi,
  epsilon_W,
  epsilon_alpha,
  epsilon_zeta,
  epsilon_min_logit,
  n,
  J,
  K
)
}
\arguments{
\item{X}{matrix. The design matrix containing sample-level covariates, one
sample per row.}

\item{V}{matrix. The design matrix containing gene-level covariates, one gene
per row.}

\item{O_mu}{matrix. The offset matrix for mu.}

\item{O_pi}{matrix. The offset matrix for pi.}

\item{which_X_mu}{integer. Indeces of which columns of X to use in the
regression of mu.}

\item{which_X_pi}{integer. Indeces of which columns of X to use in the
regression of pi.}

\item{which_V_mu}{integer. Indeces of which columns of V to use in the
regression of mu.}

\item{which_V_pi}{integer. Indeces of which columns of V to use in the
regression of pi.}

\item{W}{matrix. The factors of sample-level latent factors.}

\item{beta_mu}{matrix or NULL. The coefficients of X in the regression of mu.}

\item{beta_pi}{matrix or NULL. The coefficients of X in the regression of pi.}

\item{gamma_mu}{matrix or NULL. The coefficients of V in the regression of
mu.}

\item{gamma_pi}{matrix or NULL. The coefficients of V in the regression of
pi.}

\item{alpha_mu}{matrix or NULL. The coefficients of W in the regression of
mu.}

\item{alpha_pi}{matrix or NULL. The coefficients of W in the regression of
pi.}

\item{zeta}{numeric. A vector of log of inverse dispersion parameters.}

\item{epsilon}{nonnegative scalar. Regularization parameter.}

\item{epsilon_beta_mu}{nonnegative scalar. Regularization parameter for
beta_mu.}

\item{epsilon_gamma_mu}{nonnegative scalar. Regularization parameter for
gamma_mu.}

\item{epsilon_beta_pi}{nonnegative scalar. Regularization parameter for
beta_pi.}

\item{epsilon_gamma_pi}{nonnegative scalar. Regularization parameter for
gamma_pi.}

\item{epsilon_W}{nonnegative scalar. Regularization parameter for W.}

\item{epsilon_alpha}{nonnegative scalar. Regularization parameter for alpha
(both alpha_mu and alpha_pi).}

\item{epsilon_zeta}{nonnegative scalar. Regularization parameter for zeta.}

\item{epsilon_min_logit}{scalar. Minimum regularization parameter for
parameters of the logit model, including the intercept.}

\item{n}{integer. Number of samples.}

\item{J}{integer. Number of genes.}

\item{K}{integer. Number of latent factors.}
}
\value{
an object of class \code{\linkS4class{ZinbModel}}.
}
\description{
Initialize an object of class ZinbModel
}
\details{
This is a wrapper around the new() function to create an
  instance of class \code{ZinbModel}. Rarely, the user will need to create a
  \code{ZinbModel} object from scratch, as tipically this is the result of
  \code{\link{zinbFit}}.

If any of \code{X}, \code{V}, \code{W} matrices are passed,
  \code{n}, \code{J}, and \code{K} are inferred. Alternatively, the user can
  specify one or more of \code{n}, \code{J}, and \code{K}.

The regularization parameters can be set by a unique parameter
  \code{epsilon} or specific values for the different regularization
  parameters can also be provided.
  If only \code{epsilon} is specified, the other parameters take the
  following values:
  \itemize{
  \item epsilon_beta = epsilon/J
  \item epsilon_gamma = epsilon/n
  \item epsilon_W = epsilon/n
  \item epsilon_alpha = epsilon/J
  \item epsilon_zeta = epsilon
  }
  We empirically found that large values of \code{epsilon} provide a more
  stable estimation of \code{W}.

A call with no argument has the following default values: \code{n =
  50}, \code{J = 100}, \code{K = 0}, \code{epsilon=J}.

Although it is possible to create new instances of the class by
  calling this function, this is not the most common way of creating
  \code{ZinbModel} objects. The main use of the class is within the
  \code{\link{zinbFit}} function.
}
\examples{
a <- zinbModel()
nSamples(a)
nFeatures(a)
nFactors(a)
nParams(a)
}
