% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{weighted.mean}
\alias{weighted.mean}
\alias{weighted.mean,Zi-method}
\title{Weighted Arithmetic Mean of zero inflated count data}
\usage{
\S4method{weighted.mean}{Zi}(x, w, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{w}{a numerical \code{\link[base]{vector}} of weight the same length as
x giving the weights to use for elements of x}

\item{...}{\link[stats]{weighted.mean}}
}
\value{
weighted mean value
}
\description{
Calculate a weighted mean of zero inflated count data,
additionally taking weights for structural zeros into account
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
weight <- runif(length(inputcounts(Zi)), 0.1, 1)
weighted.mean(Zi, w= weight)
}
\seealso{
\link[stats]{weighted.mean}, \link[zitools]{rowWeightedMeans},
\link[zitools]{colWeightedMeans}
}
