###
###
###

.seqnames <- paste("chr", 1:8, sep = "")

.circ_seqs <- NULL

.mseqnames <- c("Araly1_small_scaffolds")

.onLoad <- function(libname, pkgname)
{
    extdata_dir <- system.file("extdata", package=pkgname, lib.loc=libname)
    bsgenome <- BSgenome(
        organism="Arabidopsis lyrata",
        species="Arabidopsis lyrata",
        provider="JGI (http://www.jgi.doe.gov/) in collaboration with Lab of Detlef Weigel (http://www.weigelworld.org/)",
        provider_version="Assembly V1.0",
        release_date="April 7, 2008",
        release_name="The Arabidopsis lyrata genome sequence assembly v1.0",
        source_url="http://gp-edge3.jgi-psf.org:1080/Araly1/Araly1.home.html",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dir=extdata_dir
    )
    objname <- "Alyrata"
    ns <- asNamespace(pkgname)
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)
}

