\name{BSgenome.Amellifera.UCSC.apiMel2}
\docType{package}

\alias{BSgenome.Amellifera.UCSC.apiMel2-package}
\alias{BSgenome.Amellifera.UCSC.apiMel2}
\alias{Amellifera}

\title{Full genome sequences for Apis mellifera (UCSC version apiMel2)}

\description{
  Full genome sequences for Apis mellifera (Honey Bee) as provided by UCSC (apiMel2, Jan. 2005) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
GroupFa.zip from http://hgdownload.cse.ucsc.edu/goldenPath/apiMel2/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Amellifera.UCSC.apiMel2
genome <- BSgenome.Amellifera.UCSC.apiMel2
seqlengths(genome)
genome$Group1  # same as genome[["Group1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
