###
###

.pkgname <- "BSgenome.Athaliana.TAIR.04232008"

.seqnames <- paste("chr", c(1:5, "C", "M"), sep="")

.circ_seqs <- c("chrC", "chrM")

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Arabidopsis thaliana",
        species="Arabidopsis",
        provider="TAIR",
        provider_version="04232008",
        release_date="NA",
        release_name="dumped from ADB: Mar/14/08",
        source_url="ftp://ftp.arabidopsis.org/home/tair/Sequences/whole_chromosomes/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Athaliana"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

